rm(list=ls())
library(cmdstanr)
library(bayesplot)
library(posterior)
library(mcmcplots)
library(magrittr)
library(multipanelfigure)
library(data.table)
library(tidylog)
library(tidyverse)

setwd("")



#Write code to simulate from a Normal distribution with mean 0, and standard deviation 10

set.seed(123)
#x <- rpois(100, mean=0, sd=10)
#mean(x)
x <- rnorm(10000, mean=0, sd=10)
mean(x)
sd(x)



example1 <- cmdstan_model("STAN/example1.stan")
# compile=TRUE by default

example1_fit <- example1$sample(data=list(mu = 0,
                                          sigma=10),
                                      iter_warmup=1000,
                                      iter_sampling=1000,
                                      chains = 2)
example1_fit$summary()

post_draws <- example1_fit$draws() # this is how you store the chain from Stan
#figure2 <- multi_panel_figure(columns = 3, rows = 3, panel_label_type = "upper-roman")
figure1 <- multi_panel_figure(columns = 4, rows = 2, panel_label_type = "upper-roman")
figure1 %<>%
  fill_panel(mcmc_trace(post_draws,pars='x'), column = 1:2, row = 1) %<>%
  fill_panel(mcmc_dens_overlay(post_draws,pars='x'), column = 1:2, row = 2) %<>%
  fill_panel(mcmc_acf_bar(post_draws,pars='x'), column = 3:4, row = 1:2)
figure1


par(mfrow=c(1,2))
mcmc_trace(post_draws,pars='x')
mcmc_acf(post_draws,pars='x')

gridExtra::grid.arrange(mcmc_trace(post_draws,pars='x'), mcmc_acf(post_draws,pars='x'), ncol=2)

mcmcplot(as.mcmc(example1_fit$draws(format = "matrix"))) 

post_draws <- cmdstanr::as_mcmc_list(example1_fit)
head(example1_fit$draws())
mcmcplot(mcmc.list(example1_fit$draws()))
plot(as.mcmc.list(example1_fit))

as.mcmc(example1_fit$draws(format = "matrix"))
mcmcplot(as.mcmc(example1_fit$draws(format = "matrix"))) 

mcmcsae::to_mcmc(post_draws)


data.frame(summarise_draws(post_draws,mean, mcse = mcse_mean, sd, median,rhat,ess_tail))
mcse_sd_ratio <- output_summary$mcse/output_summary$sd